/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.motionblur;

import club.sk1er.motionblur.command.MotionBlurCommand;
import club.sk1er.motionblur.config.BlurConfig;
import club.sk1er.motionblur.resource.MotionBlurResourceManager;
import gg.essential.api.EssentialAPI;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.command.ICommand;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod(name="Motion Blur", modid="motionblurmod", version="2.1.1", acceptedMinecraftVersions="[1.8.9]")
public class MotionBlur {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final Map<String, FallbackResourceManager> domainResourceManagers;
    private Field cachedFastRender;
    private int ticks;
    @Mod.Instance(value="motionblurmod")
    public static MotionBlur instance;
    private File configFile;

    public MotionBlur() {
        this.domainResourceManagers = ((SimpleReloadableResourceManager)this.mc.func_110442_L()).field_110548_a;
        try {
            this.cachedFastRender = GameSettings.class.getDeclaredField("ofFastRender");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.configFile = new File("./config/motionblur.cfg");
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientCommandHandler.instance.func_71560_a((ICommand)new MotionBlurCommand());
        this.loadConfig();
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (this.domainResourceManagers != null && !this.domainResourceManagers.containsKey("motionblur")) {
            this.domainResourceManagers.put("motionblur", new MotionBlurResourceManager(this.mc.field_110452_an));
        }
        ++this.ticks;
        if (this.ticks % 5000 == 0 && this.isFastRenderEnabled() && BlurConfig.motionBlur && this.mc.field_71439_g != null && this.mc.field_71441_e != null) {
            EssentialAPI.getMinecraftUtil().sendMessage(EnumChatFormatting.RED + "[MotionBlur]", " Motion Blur is not compatible with OptiFine's Fast Render.");
        }
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        if (this.mc.field_71439_g != null && BlurConfig.motionBlur && GameSettings.func_100015_a((KeyBinding)this.mc.field_71474_y.field_151457_aa)) {
            EntityRenderer entityRenderer = this.mc.field_71460_t;
            if (entityRenderer == null) {
                return;
            }
            entityRenderer.func_175069_a(new ResourceLocation("motionblur", "motionblur"));
            ShaderGroup shaderGroup = entityRenderer.func_147706_e();
            if (shaderGroup == null) {
                return;
            }
            shaderGroup.func_148026_a(this.mc.field_71443_c, this.mc.field_71440_d);
        }
    }

    public boolean isFastRenderEnabled() {
        try {
            return this.cachedFastRender.getBoolean(this.mc.field_71474_y);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void saveConfig() {
        Configuration configuration = new Configuration(this.configFile);
        this.updateConfig(configuration, false);
        configuration.save();
    }

    private void loadConfig() {
        Configuration configuration = new Configuration(this.configFile);
        configuration.load();
        this.updateConfig(configuration, true);
        configuration.save();
    }

    private void updateConfig(Configuration config, boolean load) {
        Property property = config.get("general", "enabled", false);
        if (load) {
            BlurConfig.motionBlur = property.getBoolean();
        } else {
            property.set(BlurConfig.motionBlur);
        }
        property = config.get("general", "amount", 0);
        if (load) {
            BlurConfig.blurAmount = property.getDouble();
        } else {
            property.set(BlurConfig.blurAmount);
        }
    }
}

